#ifndef _NIOS32_BHV_MACROS_H_
#define _NIOS32_BHV_MACROS_H_

typedef ac_memport<nios32_parms::ac_word, nios32_parms::ac_Hword> ac_memory;

//! Macros for instruction behaviors.

#ifndef ac_behavior
#define ac_behavior(instr) AC_BEHAVIOR_##instr()
#endif

#define AC_BEHAVIOR_instruction() nios32_parms::nios32_isa::_behavior_instruction(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned nu)

#define AC_BEHAVIOR_begin() nios32_parms::nios32_isa::_behavior_begin()
#define AC_BEHAVIOR_end() nios32_parms::nios32_isa::_behavior_end()

#define AC_BEHAVIOR_Format_RR() nios32_parms::nios32_isa::_behavior_nios32_Format_RR(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_Ri5() nios32_parms::nios32_isa::_behavior_nios32_Format_Ri5(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_Ri4() nios32_parms::nios32_isa::_behavior_nios32_Format_Ri4(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int CONST_0, unsigned int imm4, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_RPi5() nios32_parms::nios32_isa::_behavior_nios32_Format_RPi5(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op4, unsigned int rp, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_Ri6() nios32_parms::nios32_isa::_behavior_nios32_Format_Ri6(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm6, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_Ri8() nios32_parms::nios32_isa::_behavior_nios32_Format_Ri8(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op3, unsigned int imm8, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_i9() nios32_parms::nios32_isa::_behavior_nios32_Format_i9(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm9, unsigned int CONST_1, unsigned int nu)
#define AC_BEHAVIOR_Format_i10() nios32_parms::nios32_isa::_behavior_nios32_Format_i10(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm10, unsigned int nu)
#define AC_BEHAVIOR_Format_i11() nios32_parms::nios32_isa::_behavior_nios32_Format_i11(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu)
#define AC_BEHAVIOR_Format_Ri1u() nios32_parms::nios32_isa::_behavior_nios32_Format_Ri1u(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm1u, unsigned int CONST_2, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_Ri2u() nios32_parms::nios32_isa::_behavior_nios32_Format_Ri2u(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm2u, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_i8v() nios32_parms::nios32_isa::_behavior_nios32_Format_i8v(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op2v, unsigned int imm8v, unsigned int nu)
#define AC_BEHAVIOR_Format_i6v() nios32_parms::nios32_isa::_behavior_nios32_Format_i6v(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op2v, unsigned int CONST_3, unsigned int imm6v, unsigned int nu)
#define AC_BEHAVIOR_Format_Rw() nios32_parms::nios32_isa::_behavior_nios32_Format_Rw(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_Format_i4w() nios32_parms::nios32_isa::_behavior_nios32_Format_i4w(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_4, unsigned int imm4w, unsigned int nu)
#define AC_BEHAVIOR_Format_w() nios32_parms::nios32_isa::_behavior_nios32_Format_w(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_5, unsigned int nu)

#define AC_BEHAVIOR_add() nios32_parms::nios32_isa::behavior_add(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_and1() nios32_parms::nios32_isa::behavior_and1(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_andn1() nios32_parms::nios32_isa::behavior_andn1(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_asr() nios32_parms::nios32_isa::behavior_asr(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_cmp() nios32_parms::nios32_isa::behavior_cmp(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ext16d() nios32_parms::nios32_isa::behavior_ext16d(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ext8d() nios32_parms::nios32_isa::behavior_ext8d(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ld() nios32_parms::nios32_isa::behavior_ld(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_lsl() nios32_parms::nios32_isa::behavior_lsl(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_lsr() nios32_parms::nios32_isa::behavior_lsr(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_mov() nios32_parms::nios32_isa::behavior_mov(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_nop() nios32_parms::nios32_isa::behavior_nop(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_st() nios32_parms::nios32_isa::behavior_st(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_sub() nios32_parms::nios32_isa::behavior_sub(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_usr0() nios32_parms::nios32_isa::behavior_usr0(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_or1() nios32_parms::nios32_isa::behavior_or1(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_xor1() nios32_parms::nios32_isa::behavior_xor1(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_addi() nios32_parms::nios32_isa::behavior_addi(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_and2() nios32_parms::nios32_isa::behavior_and2(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_andn2() nios32_parms::nios32_isa::behavior_andn2(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_asri() nios32_parms::nios32_isa::behavior_asri(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_bgen() nios32_parms::nios32_isa::behavior_bgen(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_cmpi() nios32_parms::nios32_isa::behavior_cmpi(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_if0() nios32_parms::nios32_isa::behavior_if0(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_if1() nios32_parms::nios32_isa::behavior_if1(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_lsli() nios32_parms::nios32_isa::behavior_lsli(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_lsri() nios32_parms::nios32_isa::behavior_lsri(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_movhi() nios32_parms::nios32_isa::behavior_movhi(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_movi() nios32_parms::nios32_isa::behavior_movi(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_skp0() nios32_parms::nios32_isa::behavior_skp0(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_skp1() nios32_parms::nios32_isa::behavior_skp1(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_subi() nios32_parms::nios32_isa::behavior_subi(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_or2() nios32_parms::nios32_isa::behavior_or2(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_xor2() nios32_parms::nios32_isa::behavior_xor2(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ldp() nios32_parms::nios32_isa::behavior_ldp(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op4, unsigned int rp, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_stp() nios32_parms::nios32_isa::behavior_stp(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op4, unsigned int rp, unsigned int imm5, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_lds() nios32_parms::nios32_isa::behavior_lds(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op3, unsigned int imm8, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_sts() nios32_parms::nios32_isa::behavior_sts(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op3, unsigned int imm8, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_syscall() nios32_parms::nios32_isa::behavior_syscall(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op3, unsigned int imm8, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_sts16s() nios32_parms::nios32_isa::behavior_sts16s(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm9, unsigned int CONST_1, unsigned int nu)
#define AC_BEHAVIOR_sts8s() nios32_parms::nios32_isa::behavior_sts8s(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm10, unsigned int nu)
#define AC_BEHAVIOR_br() nios32_parms::nios32_isa::behavior_br(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu)
#define AC_BEHAVIOR_bsr() nios32_parms::nios32_isa::behavior_bsr(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu)
#define AC_BEHAVIOR_pfx() nios32_parms::nios32_isa::behavior_pfx(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu)
#define AC_BEHAVIOR_pfxio() nios32_parms::nios32_isa::behavior_pfxio(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu)
#define AC_BEHAVIOR_ext16s() nios32_parms::nios32_isa::behavior_ext16s(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm1u, unsigned int CONST_2, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_st16s() nios32_parms::nios32_isa::behavior_st16s(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm1u, unsigned int CONST_2, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ext8s() nios32_parms::nios32_isa::behavior_ext8s(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm2u, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_st8s() nios32_parms::nios32_isa::behavior_st8s(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm2u, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_save() nios32_parms::nios32_isa::behavior_save(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op2v, unsigned int imm8v, unsigned int nu)
#define AC_BEHAVIOR_trap() nios32_parms::nios32_isa::behavior_trap(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op2v, unsigned int CONST_3, unsigned int imm6v, unsigned int nu)
#define AC_BEHAVIOR_abs() nios32_parms::nios32_isa::behavior_abs(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_call() nios32_parms::nios32_isa::behavior_call(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_fill16() nios32_parms::nios32_isa::behavior_fill16(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_fill8() nios32_parms::nios32_isa::behavior_fill8(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ifrnz() nios32_parms::nios32_isa::behavior_ifrnz(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ifrz() nios32_parms::nios32_isa::behavior_ifrz(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_jmp() nios32_parms::nios32_isa::behavior_jmp(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_lret() nios32_parms::nios32_isa::behavior_lret(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_mstep() nios32_parms::nios32_isa::behavior_mstep(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_mul() nios32_parms::nios32_isa::behavior_mul(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_neg() nios32_parms::nios32_isa::behavior_neg(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_not() nios32_parms::nios32_isa::behavior_not(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_rdctl() nios32_parms::nios32_isa::behavior_rdctl(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ret() nios32_parms::nios32_isa::behavior_ret(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_rlc() nios32_parms::nios32_isa::behavior_rlc(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_rrc() nios32_parms::nios32_isa::behavior_rrc(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_sext16() nios32_parms::nios32_isa::behavior_sext16(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_sext8() nios32_parms::nios32_isa::behavior_sext8(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_skprnz() nios32_parms::nios32_isa::behavior_skprnz(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_skprz() nios32_parms::nios32_isa::behavior_skprz(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_st16d() nios32_parms::nios32_isa::behavior_st16d(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_st8d() nios32_parms::nios32_isa::behavior_st8d(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_swap() nios32_parms::nios32_isa::behavior_swap(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_tret() nios32_parms::nios32_isa::behavior_tret(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_usr1() nios32_parms::nios32_isa::behavior_usr1(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_usr2() nios32_parms::nios32_isa::behavior_usr2(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_usr3() nios32_parms::nios32_isa::behavior_usr3(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_usr4() nios32_parms::nios32_isa::behavior_usr4(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_wrctl() nios32_parms::nios32_isa::behavior_wrctl(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu)
#define AC_BEHAVIOR_ifs() nios32_parms::nios32_isa::behavior_ifs(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_4, unsigned int imm4w, unsigned int nu)
#define AC_BEHAVIOR_skps() nios32_parms::nios32_isa::behavior_skps(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_4, unsigned int imm4w, unsigned int nu)
#define AC_BEHAVIOR_restore() nios32_parms::nios32_isa::behavior_restore(nios32_parms::ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_5, unsigned int nu)

#endif // _NIOS32_BHV_MACROS_H_
